#pragma once

#include "SampleClasses.h"
#include "MovingObject.h"
#include "Helper.h"

#include <string>
#include <vector>
#include <map>
#include <deque>
using namespace std;

#define ADDRESS unsigned long

extern bool NOW;

class MoniApplication {
public:
	MoniApplication();
	~MoniApplication();

	void Init(HWND hMainWnd = NULL);
    void Deinit();
	void OnPaint(HDC hdc, int width, int height);

	void Reset();

	map<double, double> m_Shot_map;

	LPTSTR    m_CommandLine;

	void UpdateInfo(wchar_t *info);

protected:
    // for finishing thread
    bool m_Running;
	// thread for receiving and answering packets
	static unsigned __stdcall ThreadFuncCommLoop( void* pArguments );
	void RunCommLoop();

	// combines sending / receiving and load / save of frames
	bool SendReceive(KeysPacket &keys);

	// internally used by SendReceive()
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	long ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
    void SendMyName();

	// turns ship and fires shots
	void RunTargetting(KeysPacket &keys);

	// various tests
	void RunTest(KeysPacket &keys);

	// turn and shoot as predicted
	void RunBlindShooting(KeysPacket &keys);

    // turn to next corner in pause between levels
    void Turn2Corner(KeysPacket &keys);

	// select what astro to shot next!
	void RunPrediction(double shotAngle);

	// data
	SOCKET m_Socket;
	ADDRESS m_ServerIp;
	char m_Prevframe;
	FramePacket m_OldFrame, m_CurrentFrame;

	HANDLE m_hThreadCommLoop;
	HWND m_hMainWnd;

	Statistics *m_Stats;

	// locking access to internal data
	MyCriticalSection m_DataLock;

	bool m_Restart;

	struct ObjectState {
		ObjectState();

		void UpdateCurrentObjectState(GameStatus &currentState, long currentFrameCnt, unsigned int lastShotID4Correction, long nextUpdateAllowed, wchar_t info[256]);
		void InitPredictedState(const ObjectState &curState);
		void PredictNextObjectState(const ObjectState &prevState);

		Statistics *m_Stats;

		double m_TimeStamp;

		// asteroids & UFO
		vector<MyAsteroid> m_Asteroids;

		// 0: no UFO; 1: UFO
		long m_Ufo;

		// shots
		vector<MyShot> m_Shots;

		// number of my own shots!
		long m_NumFriendlyFire;

		// my ship
		bool m_ShipPresent;
		Point m_ShipCentre;
		int m_ShipViewX, m_ShipViewY;

		long m_ViewIndex; // left: +1, right: -1
		// resulting shot angle
		double m_ShotAngle;

        // indexes to deadly objects sorted by increasing impact time
        map<double, long> m_DeadlyObjects;
        // indexes to next objects sorted by increasing time to turn - wait + hit
        map<double, long> m_NextObjects;
        // next selected target
        long m_NextTargetIndex;
        // closest target that can be hit
        long m_CloseTargetIndex;
	};

	// object states as determined from MAME data
	ObjectState m_RealObjectState;

	long m_CurrentFrameCnt;

	// shot with this ID was last used to correct shot angle
	unsigned int m_LastShotID4Correction;
	// if this number below zero correction of shot angle allowed
	long m_NextUpdateAllowed;

    unsigned long m_NextTargetID;

	// additional display info
	wchar_t m_Info[512];
	wchar_t m_Info2[512];
};

extern MoniApplication moni;
